CREATE OR REPLACE FUNCTION ADDCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF NOT  EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
					WHERE TABLE_NAME ILIKE ('rc_mdl_venda')  
						AND COLUMN_NAME ILIKE ('tp_impressao')) THEN

	ALTER TABLE public.rc_mdl_venda ADD tp_impressao text NULL;
       	RAISE NOTICE 'COLUNA tp_impressao ADICIONADA NA rc_mdl_venda!' ;
	END IF; 
END; 


$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION ADDCOLUMN()  OWNER TO POSTGRES;
SELECT ADDCOLUMN();
DROP FUNCTION ADDCOLUMN();




CREATE OR REPLACE FUNCTION ADDCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'rc_mdl_venda' 
                  and column_name='msg_venda_crediario'
	) THEN
           RAISE NOTICE 'Coluna  msg_venda_crediario  na tabela  rc_mdl_venda  ja existe!' ;
    ELSE
		ALTER TABLE public.rc_mdl_venda ADD msg_venda_crediario text NULL;
        RAISE NOTICE 'Coluna "msg_venda_crediario" criada com sucesso!';
    END IF; 
    
END; 


$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION ADDCOLUMN()  OWNER TO POSTGRES;
SELECT ADDCOLUMN();
DROP FUNCTION ADDCOLUMN();






CREATE OR REPLACE FUNCTION ADDCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'rc_mdl_venda' 
                  and column_name='dias_bloq_atraso '
	) THEN
           RAISE NOTICE 'Coluna  dias_bloq_atraso   na tabela  rc_mdl_venda  ja existe!' ;
    ELSE
		ALTER TABLE public.rc_mdl_venda ADD dias_bloq_atraso int NULL DEFAULT 0;
        RAISE NOTICE 'Coluna "dias_bloq_atraso" criada com sucesso!';
    END IF; 
    
END;


$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION ADDCOLUMN()  OWNER TO POSTGRES;
SELECT ADDCOLUMN();
DROP FUNCTION ADDCOLUMN();








DROP VIEW v_pdv_vd_cred;

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 
'Job.................:  
'Nome................: v_pdv_vd_cred 
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 04/02/2022
'Criado por..........: Eduardo Costa Moraes
'Dt Ult Alteracão....: 20/06/2022
'Alterado por........: 

'=======================================================================================
-- FARMAGOI-28347 - Venda Crediário duplicando parcelas e valor da venda -f.tipo_transacao =3

*/

create or replace
view public.v_pdv_vd_cred
as
select
	a.cd_emp,
	a.cd_filial,
	a.cd_vd,
	a.cd_cx,
	a.cd_cli,
	a.nr_ecf,
	a.dt_vd,
	a.vlr_cartao,
	b.cd_parc,
	b.dt_parc,
	b.vl_parc,
	a.qt_parc_cred,
	b.nr_fatura,
	a.cd_usu,
	coalesce(a.flag_consolidado, 0) as flag_consolidado,
	a.st_vd,
	(
	select
		case
			a.st_vd
	when 0 then 0
			when 1 then 2
			else null::integer
	end as "case") as sts_lanc_cred,
	a.nm_comprador,
	d.cd_mdl_vd,
	d.rz_cli,
	d.cgc_cpf,
	f.qt_parc,
	coalesce(e.ds_mdl_vd, ''::character varying, e.ds_mdl_vd) as ds_mdl_vd,
	e.tp_impressao,
	e.msg_venda_crediario
from pdv_vd a
	join pdv_vd_cred b on
		a.cd_emp = b.cd_emp and a.cd_filial = b.cd_filial and a.cd_vd = b.cd_vd
	join rc_cli_crediario d on
		d.cd_cli = a.cd_cli
	left join rc_mdl_venda e on
		d.cd_mdl_vd = e.cd_mdl_vd
	join pdv_vd_tef f on
		a.cd_emp = f.cd_emp and a.cd_filial = f.cd_filial and a.cd_vd = f.cd_vd and f.tipo_transacao = 3::numeric
	order by
		b.cd_parc;